define(['InputText'], function() {
	'use strict';

	describe('Input Text Directive', function () {
		var scope,
			isolateScope,
			controller,
			elm,
			element,
			label = 'testLabel',
			name = 'testName',
            capsBool = true; 

		beforeEach(function () {
			module('angularTemplateApp');

			inject(function($templateCache) {
				$templateCache.put('src/ui-components/form/controls/simple/input-text/input-text_template.html', '<input id="text-{{name}} />');
			});
		});

		describe('the directive', function () {
			beforeEach(function () {
				inject(function($rootScope, $compile, $timeout, $templateCache) {
					scope = $rootScope;
					elm = "<input-text label='" + label + "' name='" + name + "' dont-capitalize='" + capsBool + "' ng-model='scope.someText' maxlength='20'></input-text>";
					element = $compile(elm)(scope);
					scope.$digest();

					isolateScope = element.isolateScope();
					isolateScope.ngModel = 'fakeModel';
				});
			});

			it('should have isolateScope variables defined', function () {
				expect(isolateScope.label).toEqual(label);
				expect(isolateScope.name).toEqual(name);
				expect(isolateScope.errorHandling).toBeDefined(); 
			});

			it('should have several controller functions defined', function () {
				expect(isolateScope.maxlength).toBeDefined();
				expect(isolateScope.charsLeft).toBeDefined();
				expect(isolateScope.update).toBeDefined();
			});

            it('should set noCaps off', function() {
                expect(isolateScope.noCap).toEqual("off");
                capsBool = false;
            });

            it('should set noCaps on', function() {
                expect(isolateScope.noCap).toEqual("on");
            });

			it('should calculate characters left for input field', function () {
				var okayString = 'abcdef123456789', // 15 chars
					longString = 'abcdefghijkl12345678'; // 20 chars

				spyOn(document, 'getElementById').andCallFake(function() {
					return {value: okayString};
				}); 
				scope.$digest();
				isolateScope.update();

				expect(isolateScope.charsLeft()).toBe(5);

				document.getElementById.andCallFake(function() {
					return {value: longString};
				}); 
				scope.$digest();
				expect(isolateScope.charsLeft()).toBe(0);

			});
		});
	});
});